import ReCAPTCHA from "./recaptcha";
import makeAsyncScriptLoader from "react-async-script";
var callbackName = "onloadcallback";
var globalName = "grecaptcha";

function getOptions() {
  return typeof window !== "undefined" && window.recaptchaOptions || {};
}

function getURL() {
  var dynamicOptions = getOptions();
  var hostname = dynamicOptions.useRecaptchaNet ? "recaptcha.net" : "www.google.com";
  return "https://" + hostname + "/recaptcha/api.js?onload=" + callbackName + "&render=explicit";
}

export default makeAsyncScriptLoader(getURL, {
  callbackName: callbackName,
  globalName: globalName
})(ReCAPTCHA);